#!/usr/bin/env python

import sys, os, re

try:
    import chardet
except ImportError:
    print "You need universal encoding detector for this script"
    print " http://chardet.feedparser.org or apt-get install python-chardet"
    sys.exit()

regexp_language = re.compile("\* +(.+) +translation", re.IGNORECASE)
js_template = """/* This file is automaticly generated by create_language_js.py */

// some data used in the examples
Ext.namespace('Ext.exampledata');

// TODO: complete and sort the list
Ext.exampledata.languages = [
%s
];
"""

def lang_name(file):
    language = os.path.basename(file)
    m = regexp_language.search(open(file).read(512))
    if m:
	language = m.groups()[0]
    return language

def print_locale(lang_code):
    print lang_code,
    sys.stdout.flush()
    return True

def main():
    base_dir = "../../src/locale"
    base_file = lambda f: os.path.join(base_dir, f)
    try:
	locales = os.listdir(base_dir)
    except IOError:
	print "Cannot find source locale directory: %s ... exiting" % base_dir
	sys.exit()
    
    valid_file = lambda e: e.endswith(".js") and e.startswith("ext-lang-")
    char_set = lambda f: chardet.detect(open(f).read())['encoding']
    lang_code = lambda f: f[9:f.rfind(".js")]
    info_set = lambda f: (lang_name(base_file(f)), (lang_code(f), char_set(base_file(f))))
    locales = dict(info_set(file) for file in locales if valid_file(file) and print_locale(lang_code(file)))
    print "... done"
    locale_strarray = ',\n'.join(["\t[%r, %r, %r]" % (code, name, charset) \
				     for name, (code, charset) in sorted(locales.items())])
    # create languages.js
    open("languages.js", "w").write(js_template % locale_strarray)
    print "saved %d languages to languages.js" % len(locales)
        
if __name__=="__main__":
    main()
