/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.rdp5.cliprdr;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import net.propero.rdp.RdpPacket;
import net.propero.rdp.Utilities;
import net.propero.rdp.rdp5.cliprdr.ClipInterface;
import net.propero.rdp.rdp5.cliprdr.TypeHandler;

public class TextHandler
extends TypeHandler {
    public boolean formatValid(int n) {
        return n == 1;
    }

    public boolean mimeTypeValid(String string) {
        return string.equals("text");
    }

    public int preferredFormat() {
        return 1;
    }

    public Transferable handleData(RdpPacket rdpPacket, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            int n2 = rdpPacket.get8();
            if (n2 == 0) continue;
            string = string + (char)(n2 & 0xFF);
        }
        return new StringSelection(string);
    }

    public String name() {
        return "CF_TEXT";
    }

    public byte[] fromTransferable(Transferable transferable) {
        if (transferable != null) {
            String string;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                string = exception.toString();
            }
            string = string.replace('\n', '\n');
            string = Utilities.strReplaceAll(string, "\n", "\r\n");
            return string.getBytes();
        }
        return null;
    }

    public void handleData(RdpPacket rdpPacket, int n, ClipInterface clipInterface) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            int n2 = rdpPacket.get8();
            if (n2 == 0) continue;
            string = string + (char)(n2 & 0xFF);
        }
        clipInterface.copyToClipboard(new StringSelection(string));
    }

    public void send_data(Transferable transferable, ClipInterface clipInterface) {
        if (transferable != null) {
            String string;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                string = exception.toString();
            }
            string = string.replace('\n', '\n');
            string = Utilities.strReplaceAll(string, "\n", "\r\n");
            clipInterface.send_data(string.getBytes(), string.length());
        }
    }
}

