/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.rdp5;

import java.io.IOException;
import java.lang.reflect.Array;
import net.propero.rdp.Options;
import net.propero.rdp.RdesktopException;
import net.propero.rdp.RdpPacket;
import net.propero.rdp.RdpPacket_Localised;
import net.propero.rdp.crypto.CryptoException;
import net.propero.rdp.rdp5.VChannel;
import org.apache.log4j.Logger;

public class VChannels {
    protected static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$Input == null ? (class$net$propero$rdp$Input = VChannels.class$("net.propero.rdp.Input")) : class$net$propero$rdp$Input));
    public static final int WAVE_FORMAT_PCM = 1;
    public static final int WAVE_FORMAT_ADPCM = 2;
    public static final int WAVE_FORMAT_ALAW = 6;
    public static final int WAVE_FORMAT_MULAW = 7;
    public static final int CHANNEL_OPTION_INITIALIZED = Integer.MIN_VALUE;
    public static final int CHANNEL_OPTION_ENCRYPT_RDP = 0x40000000;
    public static final int CHANNEL_OPTION_COMPRESS_RDP = 0x800000;
    public static final int CHANNEL_OPTION_SHOW_PROTOCOL = 0x200000;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_INVALID_PARAMETER = -1073741811;
    public static final int STATUS_INVALID_DEVICE_REQUEST = -1073741808;
    public static final int STATUS_ACCESS_DENIED = -1073741790;
    public static final int MAX_CHANNELS = 4;
    public static final int CHANNEL_CHUNK_LENGTH = 1600;
    public static final int CHANNEL_FLAG_FIRST = 1;
    public static final int CHANNEL_FLAG_LAST = 2;
    public static final int CHANNEL_FLAG_SHOW_PROTOCOL = 16;
    private VChannel[] channels = new VChannel[4];
    private int num_channels;
    private byte[] fragment_buffer = null;
    static /* synthetic */ Class class$net$propero$rdp$Input;

    public int num_channels() {
        return this.num_channels;
    }

    public int mcs_id(int n) {
        return 1004 + n;
    }

    public VChannel channel(int n) {
        if (n < this.num_channels) {
            return this.channels[n];
        }
        return null;
    }

    public VChannel find_channel_by_channelno(int n) {
        if (n > 1003 + this.num_channels) {
            logger.warn((Object)("Channel " + n + " not defined. Highest channel defined is " + 1003 + this.num_channels));
            return null;
        }
        return this.channels[n - 1003 - 1];
    }

    public void clear() {
        this.channels = new VChannel[4];
        this.num_channels = 0;
    }

    public boolean register(VChannel vChannel) throws RdesktopException {
        if (!Options.use_rdp5) {
            return false;
        }
        if (this.num_channels >= 4) {
            throw new RdesktopException("Channel table full. Could not register channel.");
        }
        this.channels[this.num_channels] = vChannel;
        vChannel.set_mcs_id(1004 + this.num_channels);
        ++this.num_channels;
        return true;
    }

    public void channel_process(RdpPacket_Localised rdpPacket_Localised, int n) throws RdesktopException, IOException, CryptoException {
        int n2;
        boolean bl = false;
        VChannel vChannel = null;
        for (n2 = 0; n2 < this.num_channels; ++n2) {
            if (this.mcs_id(n2) != n) continue;
            vChannel = this.channels[n2];
            break;
        }
        if (n2 >= this.num_channels) {
            return;
        }
        int n3 = rdpPacket_Localised.getLittleEndian32();
        int n4 = rdpPacket_Localised.getLittleEndian32();
        if ((n4 & 1) != 0 && (n4 & 2) != 0) {
            vChannel.process((RdpPacket)rdpPacket_Localised);
        } else {
            byte[] byArray = new byte[rdpPacket_Localised.getEnd() - rdpPacket_Localised.getPosition()];
            rdpPacket_Localised.copyToByteArray(byArray, 0, rdpPacket_Localised.getPosition(), byArray.length);
            this.fragment_buffer = VChannels.append(this.fragment_buffer, byArray);
            if ((n4 & 2) != 0) {
                RdpPacket_Localised rdpPacket_Localised2 = new RdpPacket_Localised(this.fragment_buffer.length);
                rdpPacket_Localised2.copyFromByteArray(this.fragment_buffer, 0, 0, this.fragment_buffer.length);
                vChannel.process((RdpPacket)rdpPacket_Localised2);
                this.fragment_buffer = null;
            }
        }
    }

    static Object arrayExpand(Object object, int n) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        int n2 = Array.getLength(object);
        int n3 = n2 + n;
        Class<?> clazz2 = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz2, n3);
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    static byte[] append(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length <= 0) {
            return byArray2;
        }
        if (byArray2 == null || byArray2.length <= 0) {
            return byArray;
        }
        byte[] byArray3 = (byte[])VChannels.arrayExpand(byArray, byArray2.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

