/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.keymapping;

import java.awt.event.KeyEvent;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.propero.rdp.Constants;
import net.propero.rdp.Options;
import net.propero.rdp.keymapping.KeyMapException;

public class MapDef {
    private final int FLAG_SHIFT = 1;
    private final int FLAG_CTRL = 2;
    private final int FLAG_ALT = 4;
    private final int FLAG_CAPSLOCK = 8;
    private int scancode;
    private boolean ctrlDown;
    private boolean shiftDown;
    private boolean altDown;
    private boolean capslockDown;
    private char keyChar;
    private int keyCode;
    private boolean characterDef;
    private int keyLocation;

    public MapDef(char c, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.keyChar = c;
        this.characterDef = true;
        this.keyLocation = n;
        this.scancode = n2;
        this.ctrlDown = bl;
        this.altDown = bl3;
        this.shiftDown = bl2;
        this.capslockDown = bl4;
    }

    public MapDef(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.keyCode = n;
        this.characterDef = false;
        this.keyLocation = n2;
        this.scancode = n3;
        this.ctrlDown = bl;
        this.altDown = bl3;
        this.shiftDown = bl2;
        this.capslockDown = bl4;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getScancode() {
        return this.scancode;
    }

    public boolean isCharacterDef() {
        return this.characterDef;
    }

    public boolean isCtrlDown() {
        return this.ctrlDown;
    }

    public boolean isAltDown() {
        return this.altDown;
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public boolean isCapslockOn() {
        return this.capslockDown;
    }

    public int modifierDistance(KeyEvent keyEvent, boolean bl) {
        if (!this.characterDef) {
            return 0;
        }
        int n = 0;
        if (this.ctrlDown != keyEvent.isControlDown()) {
            ++n;
        }
        if (this.altDown != keyEvent.isAltDown()) {
            ++n;
        }
        if (this.shiftDown != keyEvent.isShiftDown()) {
            ++n;
        }
        if (this.capslockDown != bl) {
            ++n;
        }
        return n;
    }

    public boolean appliesTo(char c) {
        return this.characterDef && this.keyChar == c && !this.capslockDown;
    }

    protected boolean appliesToTyped(KeyEvent keyEvent) {
        return this.characterDef && this.keyChar == keyEvent.getKeyChar();
    }

    protected boolean appliesToTyped(KeyEvent keyEvent, boolean bl) {
        if (Constants.OS == 3) {
            if (Options.remap_hash && keyEvent.getKeyChar() == '\u00a7') {
                return this.characterDef && this.keyChar == '#';
            }
            if (bl && Character.isLetter(keyEvent.getKeyChar()) && Character.isUpperCase(keyEvent.getKeyChar()) && keyEvent.isShiftDown()) {
                char c = Character.toLowerCase(keyEvent.getKeyChar());
                return this.characterDef && this.keyChar == c;
            }
        }
        return this.characterDef && this.keyChar == keyEvent.getKeyChar();
    }

    protected boolean appliesToPressed(KeyEvent keyEvent) {
        if (!this.characterDef) {
            if (!(this.ctrlDown && keyEvent.isControlDown() || !this.ctrlDown)) {
                return false;
            }
            if (!(this.altDown && keyEvent.isAltDown() || !this.altDown)) {
                return false;
            }
        }
        return !this.characterDef && this.keyCode == keyEvent.getKeyCode();
    }

    public MapDef(String string) throws KeyMapException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            boolean bl = this.characterDef = Integer.parseInt(stringTokenizer.nextToken()) == 1;
            if (this.characterDef) {
                this.keyChar = (char)Integer.parseInt(stringTokenizer.nextToken());
            } else {
                this.keyCode = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.keyLocation = Integer.parseInt(stringTokenizer.nextToken());
            this.scancode = Integer.decode(stringTokenizer.nextToken());
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.shiftDown = (n & this.FLAG_SHIFT) != 0;
            this.ctrlDown = (n & this.FLAG_CTRL) != 0;
            this.altDown = (n & this.FLAG_ALT) != 0;
            this.capslockDown = (n & this.FLAG_CAPSLOCK) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new KeyMapException("" + numberFormatException.getMessage() + " is not numeric");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new KeyMapException("Not enough parameters in definition");
        }
    }

    public void writeToStream(PrintStream printStream) {
        String string = "" + (this.characterDef ? 1 : 0);
        string = string + "\t";
        string = this.characterDef ? string + this.keyChar : string + this.keyCode;
        string = string + "\t" + this.keyLocation;
        string = string + "\t0x" + Integer.toHexString(this.scancode);
        int n = 0;
        n |= this.shiftDown ? 1 : 0;
        n |= this.ctrlDown ? 2 : 0;
        n |= this.altDown ? 4 : 0;
        string = string + "\t" + (n |= this.capslockDown ? 8 : 0);
        if (!this.characterDef) {
            string = string + "\t" + KeyEvent.getKeyText(this.keyCode);
        }
        printStream.println(string);
    }
}

