/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import net.propero.rdp.Common;
import net.propero.rdp.Constants;
import net.propero.rdp.Licence;
import net.propero.rdp.MCS;
import net.propero.rdp.Options;
import net.propero.rdp.OrderException;
import net.propero.rdp.RdesktopException;
import net.propero.rdp.RdpPacket_Localised;
import net.propero.rdp.crypto.BlockMessageDigest;
import net.propero.rdp.crypto.CryptoException;
import net.propero.rdp.crypto.MD5;
import net.propero.rdp.crypto.RC4;
import net.propero.rdp.crypto.SHA1;
import net.propero.rdp.rdp5.VChannels;
import org.apache.log4j.Logger;

public class Secure {
    boolean readCert = false;
    static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$Secure == null ? (class$net$propero$rdp$Secure = Secure.class$("net.propero.rdp.Secure")) : class$net$propero$rdp$Secure));
    private Licence licence = new Licence(this);
    public static final int SEC_ENCRYPT = 8;
    public static final int SEC_LOGON_INFO = 64;
    static final int SEC_RANDOM_SIZE = 32;
    static final int SEC_MODULUS_SIZE = 64;
    static final int SEC_PADDING_SIZE = 8;
    private static final int SEC_EXPONENT_SIZE = 4;
    private static final int SEC_CLIENT_RANDOM = 1;
    static final int SEC_LICENCE_NEG = 128;
    private static final int SEC_TAG_SRV_INFO = 3073;
    private static final int SEC_TAG_SRV_CRYPT = 3074;
    private static final int SEC_TAG_SRV_3 = 3075;
    private static final int SEC_TAG_SRV_CHANNELS = 3075;
    private static final int SEC_TAG_CLI_INFO = 49153;
    private static final int SEC_TAG_CLI_CRYPT = 49154;
    private static final int SEC_TAG_CLI_CHANNELS = 49155;
    private static final int SEC_TAG_CLI_4 = 49156;
    private static final int SEC_TAG_PUBKEY = 6;
    private static final int SEC_TAG_KEYSIG = 8;
    private static final int SEC_RSA_MAGIC = 826364754;
    private MCS McsLayer = null;
    boolean licenceIssued = false;
    private RC4 rc4_enc = null;
    private RC4 rc4_dec = null;
    private RC4 rc4_update = null;
    private BlockMessageDigest sha1 = null;
    private BlockMessageDigest md5 = null;
    private int keylength = 0;
    private int enc_count = 0;
    private int dec_count = 0;
    private byte[] sec_sign_key = null;
    private byte[] sec_decrypt_key = null;
    private byte[] sec_encrypt_key = null;
    private byte[] sec_decrypt_update_key = null;
    private byte[] sec_encrypt_update_key = null;
    private byte[] sec_crypted_random = null;
    private byte[] exponent = null;
    private byte[] modulus = null;
    private byte[] server_random = null;
    private byte[] client_random = new byte[32];
    private static final byte[] pad_54 = new byte[]{54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54};
    private static final byte[] pad_92 = new byte[]{92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92};
    private VChannels channels;
    static /* synthetic */ Class class$net$propero$rdp$Secure;

    public Secure(VChannels vChannels) {
        this.channels = vChannels;
        Common.mcs = this.McsLayer = new MCS(vChannels);
        this.rc4_dec = new RC4();
        this.rc4_enc = new RC4();
        this.rc4_update = new RC4();
        this.sha1 = new SHA1();
        this.md5 = new MD5();
        this.sec_sign_key = new byte[16];
        this.sec_decrypt_key = new byte[16];
        this.sec_encrypt_key = new byte[16];
        this.sec_decrypt_update_key = new byte[16];
        this.sec_encrypt_update_key = new byte[16];
        this.sec_crypted_random = new byte[64];
    }

    public void connect(InetAddress inetAddress, int n) throws UnknownHostException, IOException, RdesktopException, SocketException, CryptoException, OrderException {
        InetAddress inetAddress2;
        if (Options.hostname == "") {
            inetAddress2 = InetAddress.getLocalHost();
            String string = inetAddress2.getHostName();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            Options.hostname = stringTokenizer.nextToken();
            Options.hostname.trim();
        }
        inetAddress2 = this.sendMcsData();
        this.McsLayer.connect(inetAddress, n, (RdpPacket_Localised)inetAddress2);
        this.processMcsData((RdpPacket_Localised)inetAddress2);
        if (Constants.encryption) {
            this.establishKey();
        }
    }

    public void connect(InetAddress inetAddress) throws IOException, RdesktopException, OrderException, CryptoException {
        this.connect(inetAddress, Options.port);
    }

    public void disconnect() {
        this.McsLayer.disconnect();
    }

    public RdpPacket_Localised sendMcsData() {
        logger.debug((Object)"Secure.sendMcsData");
        RdpPacket_Localised rdpPacket_Localised = new RdpPacket_Localised(512);
        int n = 2 * (Options.hostname == null ? 0 : Options.hostname.length());
        if (n > 30) {
            n = 30;
        }
        int n2 = 158;
        if (Options.use_rdp5) {
            n2 += 92;
        }
        if (Options.use_rdp5 && this.channels.num_channels() > 0) {
            n2 += this.channels.num_channels() * 12 + 8;
        }
        rdpPacket_Localised.setBigEndian16(5);
        rdpPacket_Localised.setBigEndian16(20);
        rdpPacket_Localised.set8(124);
        rdpPacket_Localised.setBigEndian16(1);
        rdpPacket_Localised.setBigEndian16(n2 | 0x8000);
        rdpPacket_Localised.setBigEndian16(8);
        rdpPacket_Localised.setBigEndian16(16);
        rdpPacket_Localised.set8(0);
        rdpPacket_Localised.setLittleEndian16(49153);
        rdpPacket_Localised.set8(0);
        rdpPacket_Localised.setLittleEndian32(1633908036);
        rdpPacket_Localised.setBigEndian16(n2 - 14 | 0x8000);
        rdpPacket_Localised.setLittleEndian16(49153);
        rdpPacket_Localised.setLittleEndian16(Options.use_rdp5 ? 212 : 136);
        rdpPacket_Localised.setLittleEndian16(Options.use_rdp5 ? 4 : 1);
        rdpPacket_Localised.setLittleEndian16(8);
        rdpPacket_Localised.setLittleEndian16(Options.width);
        rdpPacket_Localised.setLittleEndian16(Options.height);
        rdpPacket_Localised.setLittleEndian16(51713);
        rdpPacket_Localised.setLittleEndian16(43523);
        rdpPacket_Localised.setLittleEndian32(Options.keylayout);
        rdpPacket_Localised.setLittleEndian32(Options.use_rdp5 ? 2600 : 419);
        rdpPacket_Localised.outUnicodeString(Options.hostname.toUpperCase(), n);
        rdpPacket_Localised.incrementPosition(30 - n);
        rdpPacket_Localised.setLittleEndian32(4);
        rdpPacket_Localised.setLittleEndian32(0);
        rdpPacket_Localised.setLittleEndian32(12);
        rdpPacket_Localised.incrementPosition(64);
        rdpPacket_Localised.setLittleEndian16(51713);
        rdpPacket_Localised.setLittleEndian16(Options.use_rdp5 ? 1 : 0);
        if (Options.use_rdp5) {
            rdpPacket_Localised.setLittleEndian32(0);
            rdpPacket_Localised.set8(Options.server_bpp);
            rdpPacket_Localised.setLittleEndian16(1792);
            rdpPacket_Localised.set8(0);
            rdpPacket_Localised.setLittleEndian32(1);
            rdpPacket_Localised.incrementPosition(64);
            rdpPacket_Localised.setLittleEndian16(49156);
            rdpPacket_Localised.setLittleEndian16(12);
            rdpPacket_Localised.setLittleEndian32(Options.console_session ? 11 : 13);
            rdpPacket_Localised.setLittleEndian32(0);
        }
        rdpPacket_Localised.setLittleEndian16(49154);
        rdpPacket_Localised.setLittleEndian16(Options.use_rdp5 ? 12 : 8);
        rdpPacket_Localised.setLittleEndian32(Options.encryption ? (Options.console_session ? 11 : 3) : 0);
        if (Options.use_rdp5) {
            rdpPacket_Localised.setLittleEndian32(0);
        }
        if (Options.use_rdp5 && this.channels.num_channels() > 0) {
            logger.debug((Object)("num_channels is " + this.channels.num_channels()));
            rdpPacket_Localised.setLittleEndian16(49155);
            rdpPacket_Localised.setLittleEndian16(this.channels.num_channels() * 12 + 8);
            rdpPacket_Localised.setLittleEndian32(this.channels.num_channels());
            for (int i = 0; i < this.channels.num_channels(); ++i) {
                logger.debug((Object)("Requesting channel " + this.channels.channel(i).name()));
                rdpPacket_Localised.out_uint8p(this.channels.channel(i).name(), 8);
                rdpPacket_Localised.setBigEndian32(this.channels.channel(i).flags());
            }
        }
        rdpPacket_Localised.markEnd();
        return rdpPacket_Localised;
    }

    public void processMcsData(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException, CryptoException {
        logger.debug((Object)"Secure.processMcsData");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        rdpPacket_Localised.incrementPosition(21);
        n2 = rdpPacket_Localised.get8();
        if ((n2 & 0x80) != 0) {
            n2 = rdpPacket_Localised.get8();
        }
        while (rdpPacket_Localised.getPosition() < rdpPacket_Localised.getEnd()) {
            n = rdpPacket_Localised.getLittleEndian16();
            n3 = rdpPacket_Localised.getLittleEndian16();
            if (n3 <= 4) {
                return;
            }
            n4 = rdpPacket_Localised.getPosition() + n3 - 4;
            switch (n) {
                case 3073: {
                    this.processSrvInfo(rdpPacket_Localised);
                    break;
                }
                case 3074: {
                    this.processCryptInfo(rdpPacket_Localised);
                    break;
                }
                case 3075: {
                    break;
                }
                default: {
                    throw new RdesktopException("Not implemented! Tag:" + n + "not recognized!");
                }
            }
            rdpPacket_Localised.setPosition(n4);
        }
    }

    private void processSrvInfo(RdpPacket_Localised rdpPacket_Localised) {
        Options.server_rdp_version = rdpPacket_Localised.getLittleEndian16();
        logger.debug((Object)("Server RDP version is " + Options.server_rdp_version));
        if (1 == Options.server_rdp_version) {
            Options.use_rdp5 = false;
        }
    }

    public void establishKey() throws RdesktopException, IOException, CryptoException {
        int n = 72;
        int n2 = 1;
        RdpPacket_Localised rdpPacket_Localised = this.init(n2, 76);
        rdpPacket_Localised.setLittleEndian32(n);
        rdpPacket_Localised.copyFromByteArray(this.sec_crypted_random, 0, rdpPacket_Localised.getPosition(), 64);
        rdpPacket_Localised.incrementPosition(64);
        rdpPacket_Localised.incrementPosition(8);
        rdpPacket_Localised.markEnd();
        this.send(rdpPacket_Localised, n2);
    }

    public void processCryptInfo(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException, CryptoException {
        int n = 0;
        n = this.parseCryptInfo(rdpPacket_Localised);
        if (n == 0) {
            return;
        }
        logger.debug((Object)("readCert = " + this.readCert));
        if (!this.readCert) {
            this.generateRandom();
            this.RSAEncrypt(32);
        }
        this.generate_keys(n);
    }

    public RdpPacket_Localised init(int n, int n2) throws RdesktopException {
        int n3 = 0;
        n3 = !this.licenceIssued ? ((n & 8) != 0 ? 12 : 4) : ((n & 8) != 0 ? 12 : 0);
        RdpPacket_Localised rdpPacket_Localised = this.McsLayer.init(n2 + n3);
        rdpPacket_Localised.pushLayer(2, n3);
        return rdpPacket_Localised;
    }

    public void send(RdpPacket_Localised rdpPacket_Localised, int n) throws RdesktopException, IOException, CryptoException {
        this.send_to_channel(rdpPacket_Localised, n, 1003);
    }

    public void send_to_channel(RdpPacket_Localised rdpPacket_Localised, int n, int n2) throws RdesktopException, IOException, CryptoException {
        int n3 = 0;
        byte[] byArray = null;
        rdpPacket_Localised.setPosition(rdpPacket_Localised.getHeader(2));
        if (!this.licenceIssued || (n & 8) != 0) {
            rdpPacket_Localised.setLittleEndian32(n);
        }
        if ((n & 8) != 0) {
            n &= 0xFFFFFFF7;
            n3 = rdpPacket_Localised.getEnd() - rdpPacket_Localised.getPosition() - 8;
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = null;
            rdpPacket_Localised.copyToByteArray(byArray2, 0, rdpPacket_Localised.getPosition() + 8, n3);
            byArray = this.sign(this.sec_sign_key, 8, this.keylength, byArray2, n3);
            byArray3 = this.encrypt(byArray2, n3);
            rdpPacket_Localised.copyFromByteArray(byArray, 0, rdpPacket_Localised.getPosition(), 8);
            rdpPacket_Localised.copyFromByteArray(byArray3, 0, rdpPacket_Localised.getPosition() + 8, n3);
        }
        this.McsLayer.send_to_channel(rdpPacket_Localised, n2);
    }

    public byte[] sign(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = new byte[16];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[n];
        this.setLittleEndian32(byArray5, n3);
        this.sha1.engineReset();
        this.sha1.engineUpdate(byArray, 0, n2);
        this.sha1.engineUpdate(pad_54, 0, 40);
        this.sha1.engineUpdate(byArray5, 0, 4);
        this.sha1.engineUpdate(byArray2, 0, n3);
        byArray3 = this.sha1.engineDigest();
        this.sha1.engineReset();
        this.md5.engineReset();
        this.md5.engineUpdate(byArray, 0, n2);
        this.md5.engineUpdate(pad_92, 0, 48);
        this.md5.engineUpdate(byArray3, 0, 20);
        byArray4 = this.md5.engineDigest();
        this.md5.engineReset();
        System.arraycopy(byArray4, 0, byArray6, 0, n);
        return byArray6;
    }

    public byte[] encrypt(byte[] byArray, int n) throws CryptoException {
        byte[] byArray2 = null;
        if (this.enc_count == 4096) {
            this.sec_encrypt_key = this.update(this.sec_encrypt_key, this.sec_encrypt_update_key);
            byte[] byArray3 = new byte[this.keylength];
            System.arraycopy(this.sec_encrypt_key, 0, byArray3, 0, this.keylength);
            this.rc4_enc.engineInitEncrypt(byArray3);
            this.enc_count = 0;
        }
        byArray2 = this.rc4_enc.crypt(byArray, 0, n);
        ++this.enc_count;
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray) throws CryptoException {
        byte[] byArray2 = null;
        if (this.enc_count == 4096) {
            this.sec_encrypt_key = this.update(this.sec_encrypt_key, this.sec_encrypt_update_key);
            byte[] byArray3 = new byte[this.keylength];
            System.arraycopy(this.sec_encrypt_key, 0, byArray3, 0, this.keylength);
            this.rc4_enc.engineInitEncrypt(byArray3);
            this.enc_count = 0;
        }
        byArray2 = this.rc4_enc.crypt(byArray);
        ++this.enc_count;
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray, int n) throws CryptoException {
        byte[] byArray2 = null;
        if (this.dec_count == 4096) {
            this.sec_decrypt_key = this.update(this.sec_decrypt_key, this.sec_decrypt_update_key);
            byte[] byArray3 = new byte[this.keylength];
            System.arraycopy(this.sec_decrypt_key, 0, byArray3, 0, this.keylength);
            this.rc4_dec.engineInitDecrypt(byArray3);
            this.dec_count = 0;
        }
        byArray2 = this.rc4_dec.crypt(byArray, 0, n);
        ++this.dec_count;
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray) throws CryptoException {
        byte[] byArray2 = null;
        if (this.dec_count == 4096) {
            this.sec_decrypt_key = this.update(this.sec_decrypt_key, this.sec_decrypt_update_key);
            byte[] byArray3 = new byte[this.keylength];
            System.arraycopy(this.sec_decrypt_key, 0, byArray3, 0, this.keylength);
            this.rc4_dec.engineInitDecrypt(byArray3);
            this.dec_count = 0;
        }
        byArray2 = this.rc4_dec.crypt(byArray);
        ++this.dec_count;
        return byArray2;
    }

    public int parseCryptInfo(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException {
        logger.debug((Object)"Secure.parseCryptInfo");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        n8 = rdpPacket_Localised.getLittleEndian32();
        n = rdpPacket_Localised.getLittleEndian32();
        if (n == 0) {
            return 0;
        }
        n2 = rdpPacket_Localised.getLittleEndian32();
        n3 = rdpPacket_Localised.getLittleEndian32();
        if (n2 != 32) {
            throw new RdesktopException("Wrong Size of Random! Got" + n2 + "expected" + 32);
        }
        this.server_random = new byte[n2];
        rdpPacket_Localised.copyToByteArray(this.server_random, 0, rdpPacket_Localised.getPosition(), n2);
        rdpPacket_Localised.incrementPosition(n2);
        n7 = rdpPacket_Localised.getPosition() + n3;
        if (n7 > rdpPacket_Localised.getEnd()) {
            logger.debug((Object)"Reached end of crypt info prematurely ");
            return 0;
        }
        int n9 = rdpPacket_Localised.getLittleEndian32();
        logger.debug((Object)("Flags = 0x" + Integer.toHexString(n9)));
        if ((n9 & 1) != 0) {
            logger.debug((Object)"We're going for the RDP4-style encryption");
            rdpPacket_Localised.incrementPosition(8);
            while (rdpPacket_Localised.getPosition() < rdpPacket_Localised.getEnd()) {
                n4 = rdpPacket_Localised.getLittleEndian16();
                n5 = rdpPacket_Localised.getLittleEndian16();
                n6 = rdpPacket_Localised.getPosition() + n5;
                switch (n4) {
                    case 6: {
                        if (this.parsePublicKey(rdpPacket_Localised)) break;
                        return 0;
                    }
                    case 8: {
                        break;
                    }
                    default: {
                        throw new RdesktopException("Unimplemented decrypt tag " + n4);
                    }
                }
                rdpPacket_Localised.setPosition(n6);
            }
            if (rdpPacket_Localised.getPosition() == rdpPacket_Localised.getEnd()) {
                return n8;
            }
            logger.warn((Object)"End not reached!");
            return 0;
        }
        int n10 = rdpPacket_Localised.getLittleEndian32();
        int n11 = rdpPacket_Localised.getLittleEndian32();
        rdpPacket_Localised.incrementPosition(n11);
        int n12 = rdpPacket_Localised.getLittleEndian32();
        rdpPacket_Localised.incrementPosition(n12);
        this.readCert = true;
        return n8;
    }

    public void generateRandom() {
    }

    public void RSAEncrypt(int n) throws RdesktopException {
        Object object;
        byte[] byArray = new byte[n];
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        this.reverse(this.exponent);
        this.reverse(this.modulus);
        System.arraycopy(this.client_random, 0, byArray, 0, n);
        this.reverse(byArray);
        if ((this.modulus[0] & 0x80) != 0) {
            object = new byte[this.modulus.length + 1];
            System.arraycopy(this.modulus, 0, object, 1, this.modulus.length);
            object[0] = 0;
            bigInteger = new BigInteger((byte[])object);
        } else {
            bigInteger = new BigInteger(this.modulus);
        }
        if ((this.exponent[0] & 0x80) != 0) {
            object = new byte[this.exponent.length + 1];
            System.arraycopy(this.exponent, 0, object, 1, this.exponent.length);
            object[0] = 0;
            bigInteger2 = new BigInteger((byte[])object);
        } else {
            bigInteger2 = new BigInteger(this.exponent);
        }
        if ((byArray[0] & 0x80) != 0) {
            object = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, object, 1, byArray.length);
            object[0] = false;
            bigInteger3 = new BigInteger((byte[])object);
        } else {
            bigInteger3 = new BigInteger(byArray);
        }
        object = bigInteger3.modPow(bigInteger2, bigInteger);
        this.sec_crypted_random = ((BigInteger)object).toByteArray();
        if ((this.sec_crypted_random[0] & 0x80) != 0) {
            throw new RdesktopException("Wrong Sign! Expected positive Integer!");
        }
        if (this.sec_crypted_random.length > 64) {
            logger.warn((Object)"sec_crypted_random too big!");
        }
        this.reverse(this.sec_crypted_random);
        byte[] byArray2 = new byte[64];
        if (this.sec_crypted_random.length < 64) {
            System.arraycopy(this.sec_crypted_random, 0, byArray2, 0, this.sec_crypted_random.length);
            for (int i = this.sec_crypted_random.length; i < byArray2.length; ++i) {
                byArray2[i] = 0;
            }
            this.sec_crypted_random = byArray2;
        }
    }

    public boolean parsePublicKey(RdpPacket_Localised rdpPacket_Localised) throws RdesktopException {
        int n = 0;
        int n2 = 0;
        n = rdpPacket_Localised.getLittleEndian32();
        if (n != 826364754) {
            throw new RdesktopException("Wrong magic! Expected826364754got:" + n);
        }
        n2 = rdpPacket_Localised.getLittleEndian32();
        if (n2 != 72) {
            throw new RdesktopException("Wrong modulus size! Expected64+8got:" + n2);
        }
        rdpPacket_Localised.incrementPosition(8);
        this.exponent = new byte[4];
        rdpPacket_Localised.copyToByteArray(this.exponent, 0, rdpPacket_Localised.getPosition(), 4);
        rdpPacket_Localised.incrementPosition(4);
        this.modulus = new byte[64];
        rdpPacket_Localised.copyToByteArray(this.modulus, 0, rdpPacket_Localised.getPosition(), 64);
        rdpPacket_Localised.incrementPosition(64);
        rdpPacket_Localised.incrementPosition(8);
        return rdpPacket_Localised.getPosition() <= rdpPacket_Localised.getEnd();
    }

    public void reverse(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        n = 0;
        for (n2 = byArray.length - 1; n < n2; ++n, --n2) {
            by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
        }
    }

    public void reverse(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        n2 = 0;
        for (n3 = n - 1; n2 < n3; ++n2, --n3) {
            by = byArray[n2];
            byArray[n2] = byArray[n3];
            byArray[n3] = by;
        }
    }

    public byte[] hash48(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws CryptoException {
        byte[] byArray4 = new byte[20];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[48];
        int n2 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            for (int i = 0; i <= n2; ++i) {
                byArray5[i] = (byte)(n + n2);
            }
            this.sha1.engineUpdate(byArray5, 0, n2 + 1);
            this.sha1.engineUpdate(byArray, 0, 48);
            this.sha1.engineUpdate(byArray2, 0, 32);
            this.sha1.engineUpdate(byArray3, 0, 32);
            byArray4 = this.sha1.engineDigest();
            this.sha1.engineReset();
            this.md5.engineUpdate(byArray, 0, 48);
            this.md5.engineUpdate(byArray4, 0, 20);
            System.arraycopy(this.md5.engineDigest(), 0, byArray6, n2 * 16, 16);
        }
        return byArray6;
    }

    public byte[] hash16(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws CryptoException {
        this.md5.engineUpdate(byArray, n, 16);
        this.md5.engineUpdate(byArray2, 0, 32);
        this.md5.engineUpdate(byArray3, 0, 32);
        return this.md5.engineDigest();
    }

    public void make40bit(byte[] byArray) {
        byArray[0] = -47;
        byArray[1] = 38;
        byArray[2] = -98;
    }

    public byte[] update(byte[] byArray, byte[] byArray2) throws CryptoException {
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = new byte[this.keylength];
        byte[] byArray5 = new byte[byArray.length];
        this.sha1.engineReset();
        this.sha1.engineUpdate(byArray2, 0, this.keylength);
        this.sha1.engineUpdate(pad_54, 0, 40);
        this.sha1.engineUpdate(byArray, 0, this.keylength);
        byArray3 = this.sha1.engineDigest();
        this.sha1.engineReset();
        this.md5.engineReset();
        this.md5.engineUpdate(byArray2, 0, this.keylength);
        this.md5.engineUpdate(pad_92, 0, 48);
        this.md5.engineUpdate(byArray3, 0, 20);
        byArray5 = this.md5.engineDigest();
        this.md5.engineReset();
        System.arraycopy(byArray5, 0, byArray4, 0, this.keylength);
        this.rc4_update.engineInitDecrypt(byArray4);
        byArray5 = this.rc4_update.crypt(byArray5, 0, this.keylength);
        if (this.keylength == 8) {
            this.make40bit(byArray5);
        }
        return byArray5;
    }

    public void setLittleEndian32(byte[] byArray, int n) {
        byArray[3] = (byte)(n >>> 24 & 0xFF);
        byArray[2] = (byte)(n >>> 16 & 0xFF);
        byArray[1] = (byte)(n >>> 8 & 0xFF);
        byArray[0] = (byte)(n & 0xFF);
    }

    public RdpPacket_Localised receive() throws RdesktopException, IOException, CryptoException, OrderException {
        int n = 0;
        RdpPacket_Localised rdpPacket_Localised = null;
        while (true) {
            int[] nArray;
            if ((rdpPacket_Localised = this.McsLayer.receive(nArray = new int[1])) == null) {
                return null;
            }
            rdpPacket_Localised.setHeader(2);
            if (Constants.encryption || !this.licenceIssued) {
                n = rdpPacket_Localised.getLittleEndian32();
                if ((n & 0x80) != 0) {
                    this.licence.process(rdpPacket_Localised);
                    continue;
                }
                if ((n & 8) != 0) {
                    rdpPacket_Localised.incrementPosition(8);
                    byte[] byArray = new byte[rdpPacket_Localised.size() - rdpPacket_Localised.getPosition()];
                    rdpPacket_Localised.copyToByteArray(byArray, 0, rdpPacket_Localised.getPosition(), byArray.length);
                    byte[] byArray2 = this.decrypt(byArray);
                    rdpPacket_Localised.copyFromByteArray(byArray2, 0, rdpPacket_Localised.getPosition(), byArray2.length);
                }
            }
            if (nArray[0] == 1003) break;
            this.channels.channel_process(rdpPacket_Localised, nArray[0]);
        }
        rdpPacket_Localised.setStart(rdpPacket_Localised.getPosition());
        return rdpPacket_Localised;
    }

    public void generate_keys(int n) throws CryptoException {
        byte[] byArray = new byte[48];
        byte[] byArray2 = new byte[48];
        byte[] byArray3 = new byte[48];
        System.arraycopy(this.client_random, 0, byArray3, 0, 24);
        System.arraycopy(this.server_random, 0, byArray3, 24, 24);
        byArray2 = this.hash48(byArray3, this.client_random, this.server_random, 65);
        byArray = this.hash48(byArray2, this.client_random, this.server_random, 88);
        System.arraycopy(byArray, 0, this.sec_sign_key, 0, 16);
        this.sec_decrypt_key = this.hash16(byArray, this.client_random, this.server_random, 16);
        this.sec_encrypt_key = this.hash16(byArray, this.client_random, this.server_random, 32);
        if (n == 1) {
            logger.info((Object)"40 Bit Encryption enabled");
            this.make40bit(this.sec_sign_key);
            this.make40bit(this.sec_decrypt_key);
            this.make40bit(this.sec_encrypt_key);
            this.keylength = 8;
        } else {
            logger.info((Object)"128 Bit Encryption enabled");
            this.keylength = 16;
        }
        System.arraycopy(this.sec_decrypt_key, 0, this.sec_decrypt_update_key, 0, 16);
        System.arraycopy(this.sec_encrypt_key, 0, this.sec_encrypt_update_key, 0, 16);
        byte[] byArray4 = new byte[this.keylength];
        System.arraycopy(this.sec_encrypt_key, 0, byArray4, 0, this.keylength);
        this.rc4_enc.engineInitEncrypt(byArray4);
        System.arraycopy(this.sec_decrypt_key, 0, byArray4, 0, this.keylength);
        this.rc4_dec.engineInitDecrypt(byArray4);
    }

    public int getUserID() {
        return this.McsLayer.getUserID();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

