/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.propero.rdp.Bitmap;
import net.propero.rdp.CELLHEADER;
import net.propero.rdp.Options;
import net.propero.rdp.Orders;
import net.propero.rdp.RdesktopException;
import org.apache.log4j.Logger;

public class PstCache {
    protected static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$Rdp == null ? (class$net$propero$rdp$Rdp = PstCache.class$("net.propero.rdp.Rdp")) : class$net$propero$rdp$Rdp));
    public static final int MAX_CELL_SIZE = 4096;
    static int g_stamp;
    static File[] g_pstcache_fd;
    static int g_pstcache_Bpp;
    static boolean g_pstcache_enumerated;
    static /* synthetic */ Class class$net$propero$rdp$Rdp;

    protected static boolean IS_PERSISTENT(int n) {
        return n < 8 && g_pstcache_fd[n] != null;
    }

    protected static void touchBitmap(int n, int n2, int n3) {
        logger.info((Object)"PstCache.touchBitmap");
        if (!PstCache.IS_PERSISTENT(n) || n2 >= 2550) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(g_pstcache_fd[n]);
            fileOutputStream.write(PstCache.toBigEndian32(n3), 12 + n2 * (g_pstcache_Bpp * 4096 + CELLHEADER.size()), 4);
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static byte[] toBigEndian32(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n & 0xFF00), (byte)(n & 0xFF0000), (byte)(n & 0xFF000000)};
        return byArray;
    }

    static boolean pstcache_load_bitmap(int n, int n2) throws IOException, RdesktopException {
        logger.info((Object)"PstCache.pstcache_load_bitmap");
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (!Options.persistent_bitmap_caching) {
            return false;
        }
        if (!PstCache.IS_PERSISTENT(n) || n2 >= 2550) {
            return false;
        }
        FileInputStream fileInputStream = new FileInputStream(g_pstcache_fd[n]);
        int n3 = n2 * (g_pstcache_Bpp * 4096 + CELLHEADER.size());
        fileInputStream.read(byArray2, n3, CELLHEADER.size());
        CELLHEADER cELLHEADER = new CELLHEADER(byArray2);
        byArray = new byte[cELLHEADER.length];
        fileInputStream.read(byArray);
        logger.debug((Object)("Loading bitmap from disk (" + n + ":" + n2 + ")\n"));
        Bitmap bitmap = new Bitmap(byArray, cELLHEADER.width, cELLHEADER.height, 0, 0, Options.Bpp);
        Orders.cache.putBitmap(n, n2, bitmap, cELLHEADER.stamp);
        return true;
    }

    static boolean pstcache_put_bitmap(int n, int n2, byte[] byArray, int n3, int n4, int n5, byte[] byArray2) throws IOException {
        logger.info((Object)"PstCache.pstcache_put_bitmap");
        CELLHEADER cELLHEADER = new CELLHEADER();
        if (!PstCache.IS_PERSISTENT(n) || n2 >= 2550) {
            return false;
        }
        cELLHEADER.bitmap_id = byArray;
        cELLHEADER.width = n3;
        cELLHEADER.height = n4;
        cELLHEADER.length = n5;
        cELLHEADER.stamp = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(g_pstcache_fd[n]);
        int n6 = n2 * (Options.Bpp * 4096 + CELLHEADER.size());
        fileOutputStream.write(cELLHEADER.toBytes(), n6, CELLHEADER.size());
        fileOutputStream.write(byArray2);
        return true;
    }

    static int pstcache_enumerate(int n, int[] nArray) throws IOException, RdesktopException {
        byte[] byArray;
        FileInputStream fileInputStream;
        int n2;
        logger.info((Object)"PstCache.pstcache_enumerate");
        int n3 = 0;
        CELLHEADER cELLHEADER = null;
        if (!(Options.bitmap_caching && Options.persistent_bitmap_caching && PstCache.IS_PERSISTENT(n))) {
            return 0;
        }
        if (g_pstcache_enumerated) {
            return 0;
        }
        logger.debug((Object)"pstcache enumeration... ");
        for (n2 = 0; n2 < 2550 && (fileInputStream = new FileInputStream(g_pstcache_fd[n])).read(byArray = new byte[CELLHEADER.size()], n2 * (g_pstcache_Bpp * 4096 + CELLHEADER.size()), CELLHEADER.size()) > 0; ++n2) {
            int n4;
            cELLHEADER = new CELLHEADER(byArray);
            int n5 = 0;
            for (n4 = 0; n4 < cELLHEADER.bitmap_id.length; ++n4) {
                n5 += cELLHEADER.bitmap_id[n4];
            }
            if (n5 == 0) break;
            for (n4 = 0; n4 < 8; ++n4) {
                nArray[n2 * 8 + n4] = cELLHEADER.bitmap_id[n4];
            }
            if (cELLHEADER.stamp == 0) continue;
            if (Options.precache_bitmaps && Options.server_bpp > 8 && PstCache.pstcache_load_bitmap(n, n2)) {
                ++n3;
            }
            g_stamp = Math.max(g_stamp, cELLHEADER.stamp);
        }
        logger.info((Object)(n2 + " bitmaps in persistent cache, " + n3 + " bitmaps loaded in memory\n"));
        g_pstcache_enumerated = true;
        return n2;
    }

    static boolean pstcache_init(int n) {
        if (g_pstcache_enumerated) {
            return true;
        }
        PstCache.g_pstcache_fd[n] = null;
        if (!Options.bitmap_caching || !Options.persistent_bitmap_caching) {
            return false;
        }
        g_pstcache_Bpp = Options.Bpp;
        String string = "./cache/pstcache_" + n + "_" + g_pstcache_Bpp;
        logger.debug((Object)("persistent bitmap cache file: " + string));
        File file = new File("./cache/");
        if (!file.exists() && !file.mkdir()) {
            logger.warn((Object)"failed to get/make cache directory");
            return false;
        }
        File file2 = new File(string);
        try {
            if (!file2.exists() && !file2.createNewFile()) {
                logger.warn((Object)"Could not create cache file");
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        PstCache.g_pstcache_fd[n] = file2;
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        g_pstcache_fd = new File[8];
        g_pstcache_enumerated = false;
    }
}

